#ifndef GRAFTAGMULTI_H
#define GRAFTAGMULTI_H

#include "ofMain.h"
#include "ofxVectorMath.h"

#include "grafTypes.h"

class grafTagMulti
{
    public:
        grafTagMulti();
        virtual ~grafTagMulti();

        grafTagMulti(  const grafTagMulti &  mom );


        // suppression de tous les point du tableau
        void clear(bool bAdddInitStroke = true );
		void draw();
	
		void setDrawScale( float val ){ drawScale = val; }

        // création d'un nouveau point et ajout à la fin de vector pts -- utilisez cela pour le chargement des tags (et ensuite pour l'enregistrement)
        // pt     -stabilisé la position du nouveau point
        // dist   -distance de ce point par rapport au dernier (utiliser pour le calcul de la largeur de la ligne). Si la valeur = -1 cela calculera la distance du point précédent
        // angle  -distance de ce point par rapport au dernier. Si la valeur = -1 cela calculera la distance du point précédent
        // time   - time stamp associé au nouveau point. If value = -1,la durée est basée sur elapsedTime - startTime
        bool addNewPoint(ofPoint pt, float dist = -1, float angle = -1, float time = -1, bool bAverage = true);
		
        // avancer jusqu'au prochain trait
		void nextStroke();
		void cleanUpLastStroke();
	
		// calculer la distance minimum et maximum entre tous les points pour ce tag
		void calcMinMax();

        // moyenne pour la disparition
		void average();
		void averagePts( strokes * stroke );

        // obtention des données
        int     getStartPt(){		return ptStart;		 }
        int     getEndPt(){			return ptEnd;		 }


		vector <strokes>		myStrokes;            // al points in tag

		// paramètres globaux des dessins des tags
		ofPoint             rotation;
		ofPoint             position;
		float               z_const;
		float				drawScale;

		// structure des données des tags
		ofPoint             min,max,center;
		float               distMin, distMax;
		float				minPtDist;
		
		// information sur les tags
		string				tagname;
		bool                bPlayed;
		float				startTime;
		int					maxNumPts;
		int                 ptStart, ptEnd;             // start and end points. if not edited ptStart = 0 and ptEnd = lastPoint
	
    protected:




    private:
};

#endif // GRAFTAGMULTI_H
